<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\User;
use App\Qrcodedata;
use App\Truck;

class QrcodedataController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
{

    $qrcodedata = Qrcodedata::all();


    return response()->json([
        'message' => 'Qrcodedata fetched successfully',
        'data' => $qrcodedata
    ]);
}


public function getrrack()
{

    $qrcodedata = Truck::all();


    return response()->json([
        'message' => 'Qrcodedata fetched successfully',
        'data' => $qrcodedata
    ]);
}


    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(Request $request)
    {
        // Validate incoming request data
        $validatedData = $request->validate([
            'car_number' => 'required|string|max:255',
            'driver_name' => 'required|string|max:255',
            'customer_name' => 'required|string|max:255',
            'truck' => 'required|string|max:255',
        ]);

        // Create a new Qrcodedata record
        $qrcodedata = Qrcodedata::create($validatedData);

        // Return the created record as JSON
        return response()->json([
            'message' => 'Qrcodedata created successfully',
            'data' => $qrcodedata
        ], 201);
    }




    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
