@extends('layouts.admin')

@section('content')

<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0 text-dark">Edit User</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="{{ route('website') }}">Home</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('user.index') }}">User list</a></li>
                    <li class="breadcrumb-item active">Edit User</li>
                </ol>
            </div>
        </div>
    </div>
</div>

<div class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header">
                        <div class="d-flex justify-content-between align-items-center">
                            <h3 class="card-title">Edit User - {{ $user->name }}</h3>
                            <a href="{{ route('user.index') }}" class="btn btn-primary">Go Back to User List</a>
                        </div>
                    </div>
                    <div class="card-body p-0">
                        <div class="row">
                            <div class="col-12 col-lg-6 offset-lg-3 col-md-8 offset-md-2">
                                <form action="{{ route('user.update', $user->id) }}" method="POST">
                                    @csrf
                                    @method('PUT')
                                    <div class="card-body">
                                        @include('includes.errors')
                                        <div class="form-group">
                                            <label for="name">User name</label>
                                            <input type="name" name="name" class="form-control" id="name" placeholder="Enter name" value="{{ $user->name }}">
                                        </div>
                                        <div class="form-group">
                                            <label for="email">User email</label>
                                            <input type="email" name="email" class="form-control" id="email" placeholder="Enter email" value="{{ $user->email }}">
                                        </div>
                                        <div class="form-group">
                                            <label>Post Category</label>
                                            <div class="d-flex flex-wrap">
                                                @foreach($categories as $category)
                                                    <div class="custom-control custom-checkbox" style="margin-right: 20px">
                                                        <input class="custom-control-input" name="categories[]" type="checkbox" id="category{{ $category->id }}" value="{{ $category->id }}"
                                                        @if(in_array($category->id, json_decode($user->category ?? '[]'))) checked @endif>
                                                        <label for="category{{ $category->id }}" class="custom-control-label">{{ $category->id }} - {{ $category->name }}</label>
                                                    </div>
                                                @endforeach
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <label for="password">User password <small>(Enter password if you want to change.)</small></label>
                                            <input type="password" name="password" class="form-control" id="password" placeholder="Enter password">
                                        </div>
                                        <div class="form-group">
                                            <label for="email_verified_at">Expiry date</label>
                                            <input type="date" name="email_verified_at" class="form-control" id="email_verified_at" value="{{ $user->email_verified_at ? $user->email_verified_at->format('Y-m-d') : '' }}">
                                        </div>
                                        <div class="form-group">
                                            <label for="download">Download</label>
                                            <select name="download" id="download" class="form-control">
                                                <option value="">Select Option</option>
                                                <option value="1" {{ $user->download == 1 ? 'selected' : '' }}>Yes</option>
                                                <option value="null" {{ $user->download == null ? 'selected' : '' }}>No</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="card-footer">
                                        <button type="submit" class="btn btn-lg btn-primary">Update User</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection
