<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\AuthController;
use App\Http\Controllers\Api\QrcodedataController;
use App\Http\Controllers\PostController;


/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:api')->get('/user', function (Request $request) {
    return $request->user();
});


Route::post('register', [AuthController::class, 'register']);
Route::post('login', [AuthController::class, 'login']);
Route::get('post', [PostController::class, 'apipost']);

Route::get('usernamesearch', [QrcodedataController::class, 'usernamesearch']);

Route::get('namealldatasearch', [QrcodedataController::class, 'namealldatasearch']);


Route::get('carnumbersearch', [QrcodedataController::class, 'carnumbersearch']);

Route::get('drivernamesearch', [QrcodedataController::class, 'drivernamesearch']);

Route::get('customernamesearch', [QrcodedataController::class, 'customernamesearch']);


Route::get('customernamesearch', [QrcodedataController::class, 'customernamesearch']);




Route::post('create', [QrcodedataController::class, 'create']);



Route::get('qrocdedatashow', [QrcodedataController::class, 'index']);


Route::get('qrocdedatastatus', [QrcodedataController::class, 'qrocdedatastatus']);


Route::get('createtrack', [QrcodedataController::class, 'getrrack']);

Route::post('qrocdeupdate', [QrcodedataController::class, 'qrocdeupdate']);

Route::post('multicreatedata', [QrcodedataController::class, 'multicreatedata']);

Route::get('datatimesearch', [QrcodedataController::class, 'datatimesearch']);


Route::post('productiondata', [QrcodedataController::class, 'productiondata']);

Route::get('products', [QrcodedataController::class, 'products']);


Route::post('productdelete', [QrcodedataController::class, 'productdelete']);
