

<?php $__env->startSection('title', $game->title . ' - Game World'); ?>

<?php $__env->startSection('content'); ?>
<div class="container py-4">
    <div class="row">
        <!-- Game Info -->
        <div class="col-lg-8">
            <div class="card card-game">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-start mb-3">
                        <div>
                            <h1 class="fw-bold"><?php echo e($game->title); ?></h1>
                            <div class="d-flex align-items-center gap-3 mb-2">
                                <span class="badge" style="background-color: <?php echo e($game->category->color); ?>">
                                    <?php echo e($game->category->name); ?>

                                </span>
                                <?php if($game->is_featured): ?>
                                <span class="badge bg-warning text-dark">
                                    <i class="fas fa-star me-1"></i><?php echo e(__('Featured')); ?>

                                </span>
                                <?php endif; ?>
                            </div>
                            <div class="text-muted">
                                <i class="fas fa-play me-1"></i><?php echo e($game->plays_count); ?> <?php echo e(__('plays')); ?>

                            </div>
                        </div>
                        <a href="<?php echo e(route('games.play', $game->slug)); ?>" class="btn btn-game btn-lg">
                            <i class="fas fa-play me-2"></i><?php echo e(__('Play Game')); ?>

                        </a>
                    </div>
                    
                    <?php if($game->thumbnail): ?>
                    <div class="mb-4">
                        <img src="<?php echo e(asset('storage/' . $game->thumbnail)); ?>" 
                             class="img-fluid rounded" alt="<?php echo e($game->title); ?>"
                             style="max-height: 300px; width: 100%; object-fit: cover;">
                    </div>
                    <?php endif; ?>
                    
                    <?php if($game->description): ?>
                    <div class="mb-4">
                        <h5><?php echo e(__('About This Game')); ?></h5>
                        <p class="text-muted"><?php echo e($game->description); ?></p>
                    </div>
                    <?php endif; ?>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <h6><?php echo e(__('Game Details')); ?></h6>
                            <ul class="list-unstyled">
                                <li><strong><?php echo e(__('Category')); ?>:</strong> <?php echo e($game->category->name); ?></li>
                                <li><strong><?php echo e(__('Class Level')); ?>:</strong> <?php echo e($game->category->class_level); ?></li>
                                <li><strong><?php echo e(__('Dimensions')); ?>:</strong> <?php echo e($game->width); ?>x<?php echo e($game->height); ?></li>
                                <li><strong><?php echo e(__('Total Plays')); ?>:</strong> <?php echo e($game->plays_count); ?></li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Sidebar -->
        <div class="col-lg-4">
            <!-- Quick Play -->
            <div class="card card-game mb-4">
                <div class="card-body text-center">
                    <h5 class="card-title"><?php echo e(__('Ready to Play?')); ?></h5>
                    <p class="card-text text-muted"><?php echo e(__('Click the button below to start playing!')); ?></p>
                    <a href="<?php echo e(route('games.play', $game->slug)); ?>" class="btn btn-game btn-lg w-100">
                        <i class="fas fa-play me-2"></i><?php echo e(__('Play Now')); ?>

                    </a>
                </div>
            </div>
            
            <!-- Navigation -->
            <div class="card card-game">
                <div class="card-body">
                    <h6 class="card-title"><?php echo e(__('Navigation')); ?></h6>
                    <div class="d-grid gap-2">
                        <a href="<?php echo e(route('games.index')); ?>" class="btn btn-outline-primary">
                            <i class="fas fa-arrow-left me-2"></i><?php echo e(__('Back to Games')); ?>

                        </a>
                        <a href="<?php echo e(route('games.index', ['category' => $game->category->slug])); ?>" class="btn btn-outline-secondary">
                            <i class="fas fa-list me-2"></i><?php echo e(__('More from')); ?> <?php echo e($game->category->name); ?>

                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\laravel_game\laravel_game\resources\views/games/show.blade.php ENDPATH**/ ?>