

<?php $__env->startSection('title', 'Users - Admin Panel'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid py-4">
    <div class="row">
        <!-- Sidebar -->
        <div class="col-lg-3 mb-4">
            <?php echo $__env->make('admin.partials.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>
        
        <!-- Main Content -->
        <div class="col-lg-9">
            <div class="admin-content p-4">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h2 class="fw-bold"><?php echo e(__('Users')); ?></h2>
                    <a href="<?php echo e(route('admin.users.create')); ?>" class="btn btn-game">
                        <i class="fas fa-plus me-2"></i><?php echo e(__('Add User')); ?>

                    </a>
                </div>
                
                <?php if($users->count() > 0): ?>
                <div class="card card-game">
                    <div class="card-body p-0">
                        <div class="table-responsive">
                            <table class="table table-hover mb-0">
                                <thead class="table-light">
                                    <tr>
                                        <th><?php echo e(__('User')); ?></th>
                                        <th><?php echo e(__('Role')); ?></th>
                                        <th><?php echo e(__('Class Level')); ?></th>
                                        <th><?php echo e(__('Categories')); ?></th>
                                        <th><?php echo e(__('Status')); ?></th>
                                        <th><?php echo e(__('Last Login')); ?></th>
                                        <th><?php echo e(__('Joined')); ?></th>
                                        <th width="200"><?php echo e(__('Actions')); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td>
                                            <div class="d-flex align-items-center">
                                                <?php if($user->avatar): ?>
                                                    <img src="<?php echo e(asset('storage/' . $user->avatar)); ?>" 
                                                         alt="<?php echo e($user->name); ?>" 
                                                         class="rounded-circle me-3" 
                                                         style="width: 40px; height: 40px; object-fit: cover;">
                                                <?php else: ?>
                                                    <div class="bg-primary rounded-circle me-3 d-flex align-items-center justify-content-center text-white" 
                                                         style="width: 40px; height: 40px;">
                                                        <?php echo e(strtoupper(substr($user->name, 0, 1))); ?>

                                                    </div>
                                                <?php endif; ?>
                                                <div>
                                                    <strong><?php echo e($user->name); ?></strong>
                                                    <br><small class="text-muted"><?php echo e($user->email); ?></small>
                                                </div>
                                            </div>
                                        </td>
                                        <td>
                                            <?php if($user->role === 'admin'): ?>
                                                <span class="badge bg-danger"><?php echo e(__('Admin')); ?></span>
                                            <?php else: ?>
                                                <span class="badge bg-info"><?php echo e(__('Student')); ?></span>
                                            <?php endif; ?>
                                        </td>
                                        <td><?php echo e($user->getClassLevelsString()); ?></td>
                                        <td>
                                            <?php if($user->categories->count() > 0): ?>
                                                <?php $__currentLoopData = $user->categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <span class="badge me-1" style="background-color: <?php echo e($category->color ?? '#6c757d'); ?>;">
                                                        <?php echo e($category->name); ?>

                                                    </span>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <?php else: ?>
                                                <span class="text-muted"><?php echo e(__('No categories assigned')); ?></span>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <?php if($user->is_active): ?>
                                                <span class="badge bg-success"><?php echo e(__('Active')); ?></span>
                                            <?php else: ?>
                                                <span class="badge bg-secondary"><?php echo e(__('Inactive')); ?></span>
                                            <?php endif; ?>
                                            
                                            <?php if($user->current_session_id): ?>
                                                <br><small class="text-success">
                                                    <i class="fas fa-circle me-1" style="font-size: 8px;"></i><?php echo e(__('Online')); ?>

                                                </small>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <?php if($user->last_login_at): ?>
                                                <?php echo e($user->last_login_at->diffForHumans()); ?>

                                            <?php else: ?>
                                                <span class="text-muted"><?php echo e(__('Never')); ?></span>
                                            <?php endif; ?>
                                        </td>
                                        <td><?php echo e($user->created_at->format('M d, Y')); ?></td>
                                        <td>
                                            <div class="btn-group" role="group">
                                                <a href="<?php echo e(route('admin.users.show', $user)); ?>" 
                                                   class="btn btn-sm btn-outline-info">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                                <a href="<?php echo e(route('admin.users.edit', $user)); ?>" 
                                                   class="btn btn-sm btn-outline-primary">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                                <?php if($user->current_session_id): ?>
                                                <button type="button" class="btn btn-sm btn-outline-warning" 
                                                        onclick="forceLogout(<?php echo e($user->id); ?>, '<?php echo e($user->name); ?>')"
                                                        title="Force logout all sessions">
                                                    <i class="fas fa-sign-out-alt"></i>
                                                </button>
                                                <?php endif; ?>
                                                <?php if($user->id !== auth()->id()): ?>
                                                <form method="POST" action="<?php echo e(route('admin.users.destroy', $user)); ?>" 
                                                      class="d-inline" onsubmit="return confirm('Are you sure? This will delete the user and all their data.')">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('DELETE'); ?>
                                                    <button type="submit" class="btn btn-sm btn-outline-danger">
                                                        <i class="fas fa-trash"></i>
                                                    </button>
                                                </form>
                                                <?php endif; ?>
                                            </div>
                                        </td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
                
                <!-- Pagination -->
                <div class="d-flex justify-content-center mt-4">
                    <?php echo e($users->links()); ?>

                </div>
                <?php else: ?>
                <div class="text-center py-5">
                    <div class="card card-game">
                        <div class="card-body py-5">
                            <i class="fas fa-users fa-4x text-muted mb-3"></i>
                            <h3 class="text-muted"><?php echo e(__('No users found')); ?></h3>
                            <p class="text-muted"><?php echo e(__('Create your first user to get started.')); ?></p>
                            <a href="<?php echo e(route('admin.users.create')); ?>" class="btn btn-game">
                                <i class="fas fa-plus me-2"></i><?php echo e(__('Add User')); ?>

                            </a>
                        </div>
                    </div>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('styles'); ?>
<style>
    .admin-sidebar {
        background: rgba(255,255,255,0.95);
        backdrop-filter: blur(10px);
        min-height: calc(100vh - 80px);
        border-radius: 15px;
        box-shadow: 0 5px 15px rgba(0,0,0,0.1);
    }
    
    .admin-content {
        background: rgba(255,255,255,0.95);
        backdrop-filter: blur(10px);
        border-radius: 15px;
        box-shadow: 0 5px 15px rgba(0,0,0,0.1);
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
function forceLogout(userId, userName) {
    if (confirm(`Are you sure you want to force logout all sessions for ${userName}? This will immediately disconnect them from all devices.`)) {
        fetch(`<?php echo e(url('/admin/users')); ?>/${userId}/force-logout`, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
            },
            body: JSON.stringify({
                user_id: userId
            })
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                alert(data.message);
                location.reload(); // Refresh the page to update the online status
            } else {
                alert('Error: ' + (data.message || 'Failed to logout user'));
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert('An error occurred while trying to logout the user.');
        });
    }
}
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\laravel_game\laravel_game\resources\views/admin/users/index.blade.php ENDPATH**/ ?>