<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Bussiness;
use App\Models\ShopConnection;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\DB;




class BussinessController extends Controller
{
    

    public function shoplistbyuser(Request $request): JsonResponse
    {

        $businesses = DB::table('bussinesses')
    ->join('shop_connections', 'bussinesses.id', '=', 'shop_connections.shop_id')
    ->select(
        'bussinesses.*',
    )->where('shop_connections.user_id',$request->id)
    ->get();

        return response()->json([
            'status' => 200,
            'message' => 'Businesses retrieved successfully',
            'data' => $businesses,
        ], 200);
    }

    /**
     * Store a new business.
     */
    public function createbussiness(Request $request): JsonResponse
    {
        $request->validate([
            'name' => 'required|string',
            'created_by' => 'required|integer',
           
        ]);

        $business = Bussiness::create($request->all());

        $connect = new ShopConnection();
        $connect->shop_id = $business->id;
        $connect->user_level = 1;
        $connect->user_id = $request->created_by;
        $connect->save();

        return response()->json([
            'status' => 200,
            'message' => 'Business created successfully',
            'data' => $business,
        ], 200);
    }

    public function add_another_user_business(Request $request): JsonResponse
    {
        $request->validate([
            'user_id' => 'required|integer',
            'business_id' => 'required|integer',
            'user_level' => 'required|integer',
           
        ]);

        $connect = new ShopConnection();
        $connect->shop_id =  $request->business_id;
        $connect->user_level =  $request->user_level;
        $connect->user_id = $request->user_id;
        $connect->save();

        return response()->json([
            'status' => 200,
            'message' => 'Added user successfully',
        ], 200);
    }

    public function remove_shop_connection(Request $request): JsonResponse
    {
        $request->validate([
            'user_id' => 'required|integer',
            'business_id' => 'required|integer',
           
        ]);

        
    // Step 2: Attempt to find and delete the connection
    $deleted = ShopConnection::where('user_id', $request->user_id)
    ->where('shop_id', $request->business_id)
    ->delete();

// Step 3: Return response
       if ($deleted) {


        return response()->json([
            'status' => 200,
            'message' => 'removed user successfully',
        ], 200);


      } else {


        return response()->json([
            'status' => 201,
            'message' => 'not matching user not found',
        ], 200);

      }

        return response()->json([
            'status' => 200,
            'message' => 'Added user successfully',
        ], 200);
    }

    /**
     * Get a specific business.
     */
    public function showbusiness(Request $request): JsonResponse
    {
        return response()->json([
            'status' => true,
            'message' => 'Business retrieved successfully',
            'data' => Bussiness::find($request->id),
        ], 200);
    }

    /**
     * Update business details.
     */
    public function updatebusiness(Request $request): JsonResponse
    {
        $request->validate([
            'id' => 'integer',
            'name' => 'string',
            'type' => 'integer',
            
        ]);

        $business = Bussiness::find($request->id);

        $business->update($request->all());

        return response()->json([
            'status' => true,
            'message' => 'Business updated successfully',
            'data' => $business,
        ], 200);
    }

    /**
     * Delete a business.
     */
    public function deleteBussiness(Request $request): JsonResponse
    {

        $business = Bussiness::find($request->id);

        $business->status = 2025;
        $business->save();

        return response()->json([
            'status' => true,
            'message' => 'Business deleted successfully',
        ], 200);
    }




}
