<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Customer;
use App\Models\State;
use Illuminate\Support\Facades\DB;




class CustomerController extends Controller
{
    
    // 📌 1️⃣ Get all businesses
    public function customerlist(Request $request) {


        $page =  $request->page;
        $limit = 10;
        $offset = ($page - 1) * $limit;


        $customers = DB::table('customers')
    ->leftJoin('townships', 'customers.township', '=', 'townships.id')
    ->leftJoin('districts', 'districts.id', '=', 'townships.district_id')
    ->leftJoin('states', 'customers.city', '=', 'states.id')
    ->leftJoin('countries', 'customers.country', '=', 'countries.id')
    ->select(
        'customers.*',
        'townships.name as township_name',
        'states.name as city_name',
        'countries.name as country_name',
        'districts.name as districts_name'
    )
    ->where('customers.business_id',$request->business_id)
    ->orderBy('customers.created_at', 'desc')
    ->offset($offset)
    ->limit($limit)
    ->get();

     return   response()->json([
        'status' => 200,
        'message' => 'customer list',
         'count' => Customer::where('business_id',$request->business_id)->count(),
        'data' => $customers
    ], 200);

        
       
    }

    // 📌 1️⃣ Get all businesses
    public function searchcustomerlist(Request $request) {


        $page = (int) $request->query('page', 1);
        $limit = 10;
        $offset = ($page - 1) * $limit;

       $search = trim($request->query('search', ''));


       
$query = DB::table('customers')
    ->leftJoin('townships', 'customers.township', '=', 'townships.id')
    ->leftJoin('districts', 'districts.id', '=', 'townships.district_id')
    ->leftJoin('states', 'customers.city', '=', 'states.id')
    ->leftJoin('countries', 'customers.country', '=', 'countries.id')
    ->select(
        'customers.*',
        'townships.name as township_name',
        'states.name as city_name',
        'countries.name as country_name',
         'districts.name as districts_name'
    )
    ->where('customers.business_id', $request->business_id);

if (!empty($search)) {
    $query->where('customers.name', 'like', '%' . $search . '%');
}

$customers = $query
    ->offset($offset)
    ->limit($limit)
    ->get();

     return   response()->json(['status' => 200,'message' => 'customer list','data' => $customers], 200);

        
       
    }

    

    // 📌 2️⃣ Store new business
    public function createcustomer(Request $request) {
        $validated = $request->validate([
            'name' => 'required|string|max:255',
            'type' => 'required|integer',
            'phone' => 'nullable|string|max:20',
            'email' => 'nullable|email|max:255',
            'address' => 'nullable|string',
            'township' => 'nullable|integer',
            'city' => 'nullable|integer',
            'country' => 'nullable|integer',
            'business_id' => 'required|integer',
           
        ]);

        $business = Customer::create($validated);
      return  response()->json(['status' => 200,'message' => 'customer is created'], 200);
       
    }

    // 📌 3️⃣ Get a single business
    public function showcustomer($id) {
        $business = Customer::find($id);
        if (!$business) {
            return response()->json(['message' => 'customer not found'], 404);
        }
        return response()->json($business, 200);
    }

    // 📌 4️⃣ Update business
    public function updatecustomer(Request $request, $id) {
        $business = Customer::find($id);
        if (!$business) {
            return response()->json(['message' => 'customer not found'], 404);
        }

        $validated = $request->validate([
            'name' => 'sometimes|required|string|max:255',
            'type' => 'sometimes|required|integer',
            'phone' => 'nullable|string|max:20',
            'email' => 'nullable|email|max:255',
            'address' => 'nullable|string',
            'township' => 'nullable|integer',
            'city' => 'nullable|integer',
            'country' => 'nullable|integer',
            'business_id' => 'sometimes|required|integer',
            'status' => 'nullable|integer',
        ]);

        $business->update($validated);
        return response()->json($business, 200);
    }

    // 📌 5️⃣ Delete business
    public function deletecustomer($id) {
        $business = Customer::find($id);
        if (!$business) {
            return response()->json(['message' => 'customer not found'], 404);
        }

        $business->delete();
        return response()->json(['message' => 'customer deleted'], 200);
    }


}
