<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Expense;
use App\Models\Expensecategory;
use App\Models\Expenselog;

class ExpenseController extends Controller
{
    

     // Display a listing of the resource
     public function index()
     {
         $expenses = Expense::all();
         return response()->json($expenses);
     }
 
     // Store a newly created resource
     public function create_expense(Request $request)
     {
         $request->validate([
             'title' => 'required|string|max:255',
             'amount' => 'required|integer|min:1',
             'category_id' => 'required|integer',
             'business_id' => 'required|integer',
             'created_by' => 'required|integer',
         ]);
 
         $expense = Expense::create($request->all());
         
         // Insert into expenselog table
         Expenselog::create([
             'expense_id' => $expense->id,
             'action' => 'created',
             'created_by' => $request->created_by,
         ]);

         $response_expense = Expense::with('Expensecategory:id,name')->findOrFail($expense->id);


         return response()->json(['message' => 'inserted successfully','data'=> $response_expense]);

     }
 
     // Display the specified resource
     public function show($id)
     {
         $expense = Expense::findOrFail($id);
         return response()->json($expense);
     }
 
     // Update the specified resource
     public function update_expense(Request $request)
     {
         $request->validate([
             'title' => 'sometimes|required|string|max:255',
             'amount' => 'sometimes|required|integer|min:1',
             'category_id' => 'sometimes|required|integer',
             'business_id' => 'sometimes|required|integer',
             'created_by' => 'sometimes|required|integer',
             'confirmed_status' => 'sometimes|required|integer|in:0,1',
         ]);
 
         $expense = Expense::findOrFail($request->id);
         $expense->update($request->all());
         
         // Insert update action into expenselog table
         ExpenseLog::create([
             'expense_id' => $expense->id,
             'action' => 'updated',
             'created_by' => $request->created_by,
         ]);

         return response()->json(['message' => 'updated successfully','data'=> $expense]);

         
     }
 
     // Remove the specified resource
     public function delete_expense(Request $request)
     {
         $expense = Expense::findOrFail($request->id);
         $expense->delete();
         
         // Insert delete action into expenselog table
         ExpenseLog::create([
             'expense_id' => $request->id,
             'action' => 'deleted',
             'created_by' => $request->created_by,
         ]);
         
         return response()->json(['message' => 'Deleted successfully']);
     }



}
