<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Expensecategory;


class ExpensecategoryController extends Controller
{
    

     // Display a listing of the resource
     public function expense_category_by_business(Request $request)
     {

        $data = Expensecategory::where('business_id',$request->business_id)->get();
        
         return response()->json(['message' => 'success','data'=>$data]);

        

     }
 
     // Store a newly created resource
     public function create_expense_category(Request $request)
     {
         $request->validate([
             'name' => 'required|string|max:255',
             'business_id' => 'required|integer',
            
         ]);
 
         $category = Expensecategory::create($request->all());

         return response()->json(['message' => 'Deleted successfully','data' => $category]);

        
     }
 
     // Display the specified resource
     public function show($id)
     {
         $category = Expensecategory::findOrFail($id);
         return response()->json($category);
     }
 
     // Update the specified resource
     public function update_expense_category(Request $request, $id)
     {
         $request->validate([
             'name' => 'sometimes|required|string|max:255',
             'business_id' => 'sometimes|required|integer',
         ]);
 
         $category = Expensecategory::findOrFail($id);
         $category->update($request->all());
         return response()->json($category);
     }
 
     // Remove the specified resource
     public function delete_expense_category(Request $request)
     {

         $category = Expensecategory::findOrFail($request->id);
         $category->expenses()->delete();
         $category->delete();
         return response()->json(['message' => 'Deleted successfully']);
     }



}
