<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\State;
use App\Models\Country;
use App\Models\District;


class LocationController extends Controller
{

    public function Countrylist() {

        
        $datalist = Country::all();
        return response()->json(['message' => 'country  found','data' => $datalist], 200);
       
    }

     public function statelistByCountry(Request $request) {

        
        $datalist = State::where('country_id',$request->country_id)->get();
        return response()->json(['message' => 'state  found','data' => $datalist], 200);
       
    }

    // 📌 1️⃣ Get all businesses
     public function districtlistByState(Request $request) {

        
        $datalist = District::with('townships')
        ->when($request->state_id, function ($query) use ($request) {
            $query->where('state_id', $request->state_id);
        })
        ->get();
        return response()->json(['message' => 'district  found','data' => $datalist], 200);
       
    }



}
