<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Product;
use App\Models\Productvariant;
use App\Models\ProductBuyingLog;
use App\Models\ProductSellingPrice;
use App\Models\Productcategory;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;

class ProductController extends Controller
{
    

    public function Create(Request $request)
    {
        $validated = $request->validate([
            'product_category_id' => 'required',
            'name' => 'required',
            'business_id' => 'required|integer',
            'product_variant' => 'required|array',
        ]);

        $product = Product::create($validated);

        foreach ($request->product_variant as $item) {

            $variant = new Productvariant();
            $variant->product_id = $product->id;
            $variant->name = $item['item_name'];
            $variant->current_selling_price = $item['current_selling_price'];
            $variant->total_quantity = $item['quantity'];
            $variant->barcode = $item['barcode'] ?? null;
            $variant->business_id = $request->business_id;
            $variant->tax_percent = $item['tax_percent'] ?? null;
            $variant->tax_amount = $item['tax_amount'] ?? null;
            $variant->discount_amount = $item['discount_amount'] ?? null;
            $variant->discount_type = $item['discount_type'] ?? null;
            $variant->save();

            $lastvariant = Productvariant::latest()->first();

            $productbuyinglog = new ProductBuyingLog();
            $productbuyinglog->product_variant_id = $lastvariant->id;
            $productbuyinglog->buy_date = Carbon::now()->toDateTimeString();
            $productbuyinglog->buy_price = $item['buying_price'];
            $productbuyinglog->purchase_quantity = $item['quantity'];
            $productbuyinglog->expired_date = $item['expired_date'] ?? null;
            $productbuyinglog->business_id = $request->business_id;
            $productbuyinglog->save();

              foreach ($item['selling_price'] as $priceitem) {

                  $sellingprice = new ProductSellingPrice();
                  $sellingprice->product_id = $lastvariant->id;
                  $sellingprice->uom_id = $priceitem['uom_id'];;
                  $sellingprice->min_qty = $priceitem['min_qty'];
                  $sellingprice->max_qty = $priceitem['max_qty'];
                  $sellingprice->price = $priceitem['price'];
                  $sellingprice->save();


              }

          

            

        }

        return response()->json(['message' => 'product created successfully', 'status' => 200]);
    }

    public function AddProduct_Variant(Request $request)
    {
        $validated = $request->validate([
            'product_id' => 'required',
            'business_id' => 'required|integer',
            'product_variant' => 'required|array',
        ]);

        foreach ($request->product_variant as $item) {

            $variant = new Productvariant();
            $variant->product_id = $request->product_id;
            $variant->name = $item['item_name'];
            $variant->current_selling_price = $item['current_selling_price'];
            $variant->total_quantity = $item['quantity'];
            $variant->barcode = $item['barcode'] ?? null;
            $variant->business_id = $request->business_id;
            $variant->tax_percent = $item['tax_percent'] ?? null;
            $variant->tax_amount = $item['tax_amount'] ?? null;
            $variant->discount_amount = $item['discount_amount'] ?? null;
            $variant->discount_type = $item['discount_type'] ?? null;
            $variant->save();

            $lastvariant = Productvariant::latest()->first();

            $productbuyinglog = new ProductBuyingLog();
            $productbuyinglog->product_variant_id = $lastvariant->id;
            $productbuyinglog->buy_date = Carbon::now()->toDateTimeString();
            $productbuyinglog->buy_price = $item['buying_price'];
            $productbuyinglog->purchase_quantity = $item['quantity'];
            $productbuyinglog->expired_date = $item['expired_date'] ?? null;
            $productbuyinglog->business_id = $request->business_id;
            $productbuyinglog->save();

        }

        return response()->json(['message' => 'product variant added successfully', 'status' => 200]);
    }

    public function AddMoreProducts(Request $request)
    {
        $validated = $request->validate([
            'product_variant_id' => 'required|integer',
            'buying_price' => 'required|integer',
            'quantity' => 'required|integer',
            'business_id' => 'required|integer',
        ]);

        $productbuyinglog = new ProductBuyingLog();
        $productbuyinglog->product_variant_id = $request->product_variant_id;
        $productbuyinglog->buy_date = Carbon::now()->toDateTimeString();
        $productbuyinglog->buy_price = $request->buying_price;
        $productbuyinglog->purchase_quantity = $request->quantity;
        $productbuyinglog->expired_date = $request->expired_date?? null;
        $productbuyinglog->business_id = $request->business_id;
        $productbuyinglog->save();


        $remainingQty = ProductBuyingLog::where('product_variant_id', $request->product_variant_id)
               ->select(DB::raw('SUM(purchase_quantity - sold_quantity) as remaining_qty'))
               ->value('remaining_qty');

        return response()->json(['message' => 'products added successfully', 'status' => 200,'remainingQty' => $remainingQty]);
    }

    public function productvariantlist(Request $request)
    {
        $validated = $request->validate([
            'business_id' => 'required|integer',
          
        ]);

        $data = DB::table('productvariants')
    ->join('products', 'productvariants.product_id', '=', 'products.id')
    ->join('productcategories', 'products.product_category_id', '=', 'productcategories.id')
    ->select(
        'productvariants.id',
        'productvariants.name',
        'productvariants.current_selling_price',
        'productvariants.business_id',
        'productvariants.product_id',
        DB::raw('COALESCE(productvariants.barcode, NULL) as barcode'),
        'productvariants.status',
        'products.name as product_name',
         'productcategories.name as category_name',
          'productcategories.id as category_id',
          DB::raw('(
            SELECT SUM(purchase_quantity - sold_quantity)
            FROM product_buying_logs
            WHERE product_variant_id = productvariants.id
        ) as total_quantity')
    )->where('productvariants.business_id',$request->business_id)
    ->get();

    foreach ($data as $variant) {
    $variant->selling_prices = DB::table('product_selling_prices')
         ->join('u_o_m_s', 'product_selling_prices.uom_id', '=', 'u_o_m_s.id')
        ->where('product_selling_prices.product_id', $variant->id) // product_id is variant ID
        ->select('product_selling_prices.id','product_selling_prices.uom_id','product_selling_prices.product_id','product_selling_prices.min_qty','product_selling_prices.max_qty','product_selling_prices.price','u_o_m_s.name as uom_name','u_o_m_s.conversion_factor as conversion_factor')
        ->get();
}

       
        return response()->json(['message' => 'product list successfully', 'status' => 200,'data'=> $data]);
    }

    public function product_variant_added_record_list(Request $request)
    {
        $validated = $request->validate([
            'product_variant_id' => 'required|integer',
          
        ]);

        $data =  ProductBuyingLog::where('product_variant_id',$request->product_variant_id)->get();

       
        return response()->json(['message' => 'product added records successfully', 'status' => 200,'data'=> $data]);
    }

    public function getProductsWithVariants(Request $request)
{

    $validated = $request->validate([
        'product_category_id' => 'required|integer',
      
    ]);

    $products = Product::with('productvariants')
        ->where('product_category_id', $request->product_category_id)
        ->get();

        return response()->json(['message' => 'product variant list query successfully', 'status' => 200,'data'=> $products]);

}

public function getProductslist(Request $request)
{

    $validated = $request->validate([
        'business_id' => 'required|integer',
    ]);

    $categories = Productcategory::withCount('products')
        ->where('business_id', $request->business_id)
        ->get();

    $products = Product::with('productvariants')
        ->where('business_id', $request->business_id)
        ->get();

        // Append remaining_quantity to each variant
    foreach ($products as $product) {
      foreach ($product->productvariants as $variant) {
        $variant->remaining_quantity = $variant->productBuyingLogs->sum(function ($log) {
            return $log->purchase_quantity - $log->sold_quantity;
        });
        unset($variant->productBuyingLogs); // optional: remove raw logs from response

         $variant->selling_prices = DB::table('product_selling_prices')
         ->join('u_o_m_s', 'product_selling_prices.uom_id', '=', 'u_o_m_s.id')
        ->where('product_selling_prices.product_id', $variant->id) // product_id is variant ID
        ->select('product_selling_prices.id','product_selling_prices.uom_id','product_selling_prices.product_id','product_selling_prices.min_qty','product_selling_prices.max_qty','product_selling_prices.price','u_o_m_s.name as uom_name','u_o_m_s.conversion_factor as conversion_factor')
        ->get();


       }

   

    }

        return response()->json(['message' => 'product variant list query successfully', 'status' => 200,'category'=> $categories,'data'=> $products]);

}

public function getProductspurchasinglist(Request $request)
{

    $validated = $request->validate([
        'product_variant_id' => 'required|integer',
      
    ]);

    $products = ProductBuyingLog::where('product_variant_id', $request->product_variant_id)
        ->get();

        return response()->json(['message' => 'product added records successfully', 'status' => 200,'data'=> $products]);

}


}
