<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Productcategory;


class ProductcategoryController extends Controller
{
    
     // 📌 1️⃣ Get all categories
     public function productcategorylist(Request $request) {

        $categories = Productcategory::withCount('products')
        ->where('business_id', $request->business_id)
        ->get();

        return response()->json(['message' => 'product category list successfully', 'status' => 200,'data'=>$categories]);
    
    }

    // 📌 2️⃣ Store new category
    public function createproductcategory(Request $request) {
        $validated = $request->validate([
            'name' => 'required|string|max:255',
            'business_id' => 'required|integer',
        ]);

        $category = Productcategory::create($validated);

        return response()->json(['message' => 'product category created successfully', 'status' => 200,'data'=>$category]);

    }

    // 📌 3️⃣ Get a single category
    public function show($id) {
        $category = Productcategory::find($id);
        if (!$category) {
            return response()->json(['message' => 'Category not found'], 404);
        }
        return response()->json($category, 200);
    }

    // 📌 4️⃣ Update category
    public function updateproductcategory(Request $request, $id) {
        $category = Productcategory::find($id);
        if (!$category) {
            return response()->json(['message' => 'Category not found'], 404);
        }

        $validated = $request->validate([
            'name' => 'sometimes|required|string|max:255',
        ]);

        $category->update($validated);
        return response()->json($category, 200);
    }

    // 📌 5️⃣ Delete category
    public function deletecategory($id) {
        $category = Productcategory::find($id);
        if (!$category) {
            return response()->json(['message' => 'Category not found'], 404);
        }

        $category->delete();
        return response()->json(['message' => 'Category deleted'], 200);
    }



}
