<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\StockOrder;
use App\Models\StockOrderItem;
use Carbon\Carbon;


class StockOrderController extends Controller
{

    public function Order_list_By_Date_Range(Request $request)
    {
    $page = (int) $request->get('page', 1);
    $limit = 10;

   
    $total = StockOrder::whereBetween('delivery_date', [$request->start, $request->end])->count();

    $totalPages = ceil($total / $limit);
    $page = max(1, min($page, $totalPages)); // Ensure valid page number

    $offset = max(0, $total - ($page * $limit));

    $orders = StockOrder::with('items')
        ->whereBetween('delivery_date', [$request->start, $request->end])
        ->orderBy('created_at', 'desc')
        ->skip($offset)
        ->take($limit)
        ->get();

    return response()->json([
        'data' => $orders,
        'total' => $total,
        'page' => $page,
        'total_pages' => $totalPages,
        'limit' => $limit,
    ]);
}

public function Order_list_By_name(Request $request)
    {
        $search = $request->input('search'); // optional cu_name search
        $page = $request->input('page', 1); // default page 1
        $limit = $request->input('limit', 10); // default 10 items per page
    
        $offset = ($page - 1) * $limit; // calculate offset from page
    
        $orders = StockOrder::with('items')
            ->when($search, function ($query, $search) {
                $query->where('cu_name', 'like', '%' . $search . '%');
            })
            ->orderBy('created_at', 'desc')
            ->skip($offset)
            ->take($limit)
            ->get();
      

    return response()->json([
        'data' => $orders,
        'total' => 0,
        'page' => $page,
        'total_pages' => 0,
        'limit' => $limit,
    ]);
}
    
    public function Tomorrow_Order_list(Request $request)
    {
    $page = (int) $request->get('page', 1);
    $limit = 10;

    $today = Carbon::tomorrow()->toDateString();// Get today's date in YYYY-MM-DD

    $total = StockOrder::whereDate('delivery_date', $today)->count();
    $totalPages = ceil($total / $limit);
    $page = max(1, min($page, $totalPages)); // Ensure valid page number

    $offset = max(0, $total - ($page * $limit));

    $orders = StockOrder::with('items')
        ->whereDate('delivery_date', $today)
        ->orderBy('created_at', 'desc')
        ->skip($offset)
        ->take($limit)
        ->get();

    return response()->json([
        'data' => $orders,
        'total' => $total,
        'page' => $page,
        'total_pages' => $totalPages,
        'limit' => $limit,
    ]);
}

    public function Yesterday_Order_list(Request $request)
    {
    $page = (int) $request->get('page', 1);
    $limit = 10;

    $today = Carbon::yesterday()->toDateString();// Get today's date in YYYY-MM-DD

    $total = StockOrder::whereDate('delivery_date', $today)->count();
    $totalPages = ceil($total / $limit);
    $page = max(1, min($page, $totalPages)); // Ensure valid page number

    $offset = max(0, $total - ($page * $limit));

    $orders = StockOrder::with('items')
        ->whereDate('delivery_date', $today)
        ->orderBy('created_at', 'desc')
        ->skip($offset)
        ->take($limit)
        ->get();

    return response()->json([
        'data' => $orders,
        'total' => $total,
        'page' => $page,
        'total_pages' => $totalPages,
        'limit' => $limit,
    ]);
}


    public function Today_Order_list(Request $request)
    {
    $page = (int) $request->get('page', 1);
    $limit = 10;

    $today = Carbon::today()->toDateString(); // Get today's date in YYYY-MM-DD

    $total = StockOrder::whereDate('delivery_date', $today)->count();
    $totalPages = ceil($total / $limit);
    $page = max(1, min($page, $totalPages)); // Ensure valid page number

    $offset = max(0, $total - ($page * $limit));

    $orders = StockOrder::with('items')
        ->whereDate('delivery_date', $today)
        ->orderBy('created_at', 'desc')
        ->skip($offset)
        ->take($limit)
        ->get();

    return response()->json([
        'data' => $orders,
        'total' => $total,
        'page' => $page,
        'total_pages' => $totalPages,
        'limit' => $limit,
    ]);
}



    public function index(Request $request)
    {
        $page = (int) $request->get('page', 1);
    $limit = 10;

    $total = StockOrder::count();
    $totalPages = ceil($total / $limit);
    $page = max(1, min($page, $totalPages)); // Ensure valid page number

    $offset = max(0, $total - ($page * $limit));

    $orders = StockOrder::with('items')
        ->orderBy('created_at', 'desc')
        ->skip($offset)
        ->take($limit)
        ->get();

    return response()->json([
        'data' => $orders,
        'total' => $total,
        'page' => $page,
        'total_pages' => $totalPages,
        'limit' => $limit,
    ]);
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'cu_name' => 'required',
            'cu_phone' => 'required',
            'cu_address' => 'required',
            'business_id' => 'required|integer',
            'order_created_by' => 'required|integer',
            'order_items' => 'required|array',
            'delivery_date' => 'required',
        ]);

        $order = StockOrder::create($validated);

        foreach ($request->order_items as $item) {
            $order->items()->create([
                'item_name' => $item['item_name'],
                'item_quantity' => $item['item_quantity'],
                'item_sell_price' => $item['item_sell_price'],
            ]);
        }

        return response()->json(['message' => 'Order created successfully', 'order' => $order->load('items')], 201);
    }

    public function show($id)
    {
        $order = StockOrder::with('items')->findOrFail($id);
        return response()->json($order);
    }

    public function update(Request $request)
    {
        $order = StockOrder::findOrFail($request->id);

        $order->update($request->only([
            'cu_name', 'cu_phone', 'cu_address',
            'business_id', 'order_created_by',
            'order_packing_by', 'order_delivery_by',  'delivery_date','status',
        ]));

        if ($request->has('order_items')) {
            $order->items()->delete(); // optional: remove existing items
            foreach ($request->order_items as $item) {
                $order->items()->create([
                    'item_name' => $item['item_name'],
                    'item_quantity' => $item['item_quantity'],
                    'item_sell_price' => $item['item_sell_price'],
                ]);
            }
        }

        return response()->json(['message' => 'Order updated successfully', 'order' => $order->load('items')]);
    }

    public function change_order_status(Request $request)
    {

        if($request->status == 2025){

            // For Delete Function

            $order = StockOrder::findOrFail($request->id);
            $order->items()->delete();
            $order->delete();
    
            return response()->json(['message' => 'Order deleted successfully', 'status' => 0, 'id' => $request->id]);

        }else{

         $order = StockOrder::findOrFail($request->id);

        $order->update($request->only([
           'status',
        ]));

        return response()->json(['message' => 'Order updated successfully', 'status' => $request->status,'id' => $request->id]);


        }

        
    }

    public function destroy($id)
    {
        $order = StockOrder::findOrFail($id);
        $order->items()->delete();
        $order->delete();

        return response()->json(['message' => 'Order deleted successfully']);
    }



}
