<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Productvariant extends Model
{
    
    protected $fillable = [
        'product_id',
        'name',
        'current_selling_price',
        'total_quantity',
        'business_id',
        'tax_percent',
        'tax_amount',
        'discount_amount',
        'discount_type',
        'barcode',
        'status'
    ];

    public function product()
{
    return $this->belongsTo(Product::class, 'product_id');
}

public function productpurchasinglist()
{
    return $this->hasMany(ProductBuyingLog::class, 'product_variant_id');
}

public function productBuyingLogs()
{
    return $this->hasMany(ProductBuyingLog::class, 'product_variant_id');
}


}
