<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('productvariants', function (Blueprint $table) {
            $table->id();
            $table->integer('product_id');
            $table->string('name');
            $table->integer('current_selling_price');
            $table->integer('total_quantity');
            $table->integer('business_id');
            $table->integer('tax_percent')->default(0);
            $table->integer('tax_amount')->default(0);
            $table->integer('discount_amount')->default(0);
            $table->integer('discount_type')->default(0);
            $table->string('barcode')->nullable();
            $table->integer('status')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('productvariants');
    }
};
