<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('expenses', function (Blueprint $table) {
            $table->id();
            $table->string('title');
            $table->integer('amount');
            $table->unsignedBigInteger('category_id');
            $table->unsignedBigInteger('business_id');
            $table->unsignedBigInteger('created_by');
            $table->integer('confirmed_status')->default(0);
            $table->timestamps();

        // Foreign key with cascade on delete
        $table->foreign('category_id')
              ->references('id')->on('expensecategories')
              ->onDelete('cascade');


        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('expenses');
    }
};
