<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('expenselogs', function (Blueprint $table) {
            $table->id();
            $table->integer('expense_id');
            $table->string('action');
            $table->integer('created_by');
            $table->integer('status')->default(0); // 0 is create , 1 is confirm , 2 is reject , 4 is updated expense
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('expenselogs');
    }
};
