<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('stock_orders', function (Blueprint $table) {
            $table->id();
            $table->string('cu_name');
            $table->string('cu_phone');
            $table->text('cu_address');
            $table->integer('business_id');
            $table->integer('order_created_by');
            $table->integer('order_packing_by')->nullable();
            $table->integer('order_delivery_by')->nullable();
            $table->date('delivery_date');
            $table->integer('status')->default(0); // 0 is pending // 1 is prepare for delivery // 2 is finished delivery
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('stock_orders');
    }
};
