<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('product_buying_logs', function (Blueprint $table) {
            $table->id();
            $table->integer('product_variant_id');
            $table->datetime('buy_date');
            $table->integer('buy_price');
            $table->integer('purchase_quantity');
            $table->integer('sold_quantity')->default(0);
            $table->date('expired_date')->nullable();
            $table->integer('business_id');
            $table->integer('status')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('product_buying_logs');
    }
};
