<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('product_selling_prices', function (Blueprint $table) {
            $table->id();
            $table->integer('product_id');
            $table->integer('uom_id');
            $table->integer('min_qty');
            $table->integer('max_qty')->nullable(); // Null = no upper limit
            $table->decimal('price', 10, 2); // Total price for this tier
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('product_selling_prices');
    }
};
