<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\District;
use App\Models\Township;

class AyeyarwadySeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        

        $data = [
            ['state_id' => '1','code' => 'AYW-D001', 'name' => 'ပုသိမ်ခရိုင်', 'townships' => [
                ['code' => 'AYW-001', 'name' => 'ပုသိမ်မြို့နယ်'],
                ['code' => 'AYW-002', 'name' => 'လပွတ်တာမြို့နယ်'],
                ['code' => 'AYW-003', 'name' => 'ငပလီမြို့နယ်'],
                ['code' => 'AYW-004', 'name' => 'ကျုံပျော်မြို့နယ်'],
                ['code' => 'AYW-005', 'name' => 'မြောင်းမြမြို့နယ်'],
                ['code' => 'AYW-006', 'name' => 'နတ်တလင်းမြို့နယ်'],
                ['code' => 'AYW-007', 'name' => 'သံပုယင်းမြို့နယ်'],
            ]],
            ['state_id' => '1','code' => 'AYW-D002', 'name' => 'ဟင်္သာတခရိုင်', 'townships' => [
                ['code' => 'AYW-008', 'name' => 'ဟင်္သာတမြို့နယ်'],
                ['code' => 'AYW-009', 'name' => 'ဇီးကြီးခနောင်တန်းမြို့နယ်'],
                ['code' => 'AYW-010', 'name' => 'ဂျင်းမူမြို့နယ်'],
                ['code' => 'AYW-011', 'name' => 'လေးမျက်နှာမြို့နယ်'],
                ['code' => 'AYW-012', 'name' => 'မယ်သမီးမြို့နယ်'],
                ['code' => 'AYW-013', 'name' => 'ဖျာပုံမြို့နယ်'],
            ]],
            ['state_id' => '1','code' => 'AYW-D003', 'name' => 'မော်လမြိုင်ကျွန်းခရိုင်', 'townships' => [
                ['code' => 'AYW-014', 'name' => 'မော်လမြိုင်ကျွန်းမြို့နယ်'],
                ['code' => 'AYW-015', 'name' => 'အိမ်မဲမြို့နယ်'],
                ['code' => 'AYW-016', 'name' => 'ဝေလမြို့နယ်'],
                ['code' => 'AYW-017', 'name' => 'မအူပင်မြို့နယ်'],
            ]],
            ['state_id' => '1','code' => 'AYW-D004', 'name' => 'ဓနုဖြူခရိုင်', 'townships' => [
                ['code' => 'AYW-018', 'name' => 'ဓနုဖြူမြို့နယ်'],
            ]],
            ['state_id' => '1','code' => 'AYW-D005', 'name' => 'ပံပင်ခရိုင်', 'townships' => [
                ['code' => 'AYW-019', 'name' => 'ပံပင်မြို့နယ်'],
            ]],
            ['state_id' => '1','code' => 'AYW-D006', 'name' => 'မအူပင်ခရိုင်', 'townships' => [
                ['code' => 'AYW-020', 'name' => 'မအူပင်မြို့နယ်'],
                ['code' => 'AYW-021', 'name' => 'နတ်တလင်မြို့နယ်'],
                ['code' => 'AYW-022', 'name' => 'ကန်ကြီးထောင့်မြို့နယ်'],
                ['code' => 'AYW-023', 'name' => 'ပုသိမ်ကြီးမြို့နယ်'],
            ]],
            ['state_id' => '1','code' => 'AYW-D007', 'name' => 'ဘိုကြီးမြို့နယ်ခရိုင်', 'townships' => [
                ['code' => 'AYW-024', 'name' => 'ဘိုကြီးမြို့နယ်'],
                ['code' => 'AYW-025', 'name' => 'ကျွက်ကြီးမြို့နယ်'],
                ['code' => 'AYW-026', 'name' => 'ငပခုတ်မြို့နယ်'],
            ]],
        ];
    
        foreach ($data as $districtData) {
            $townships = $districtData['townships'];
            unset($districtData['townships']);
    
            $district = District::create($districtData);
    
            foreach ($townships as $township) {
                $district->townships()->create($township);
            }
        }



    }
}
