<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\API\UserController;
use App\Http\Controllers\API\BussinessController;
use App\Http\Controllers\API\CustomerController;
use App\Http\Controllers\API\ProductcategoryController;
use App\Http\Controllers\API\ExpensecategoryController;
use App\Http\Controllers\API\ExpenseController;
use App\Http\Controllers\API\StockOrderController;
use App\Http\Controllers\API\ProductController;
use App\Http\Controllers\API\SaleVoucherController;
use App\Http\Controllers\API\LocationController;
use App\Http\Controllers\API\UOMController;









Route::get('/user', function (Request $request) {
    return $request->user();
})->middleware('auth:sanctum');


Route::post('/register', [UserController::class, 'register']);
Route::post('/login', [UserController::class, 'login']);


Route::post('/test', function () {
    return response()->json(['message' => 'API works']);
});


Route::post('/shoplistbyuser', [BussinessController::class, 'shoplistbyuser']);
Route::post('/createbussiness', [BussinessController::class, 'createbussiness']);
Route::post('/showbusiness', [BussinessController::class, 'showbusiness']);
Route::post('/updatebusiness', [BussinessController::class, 'updatebusiness']);
Route::post('/deleteBussiness', [BussinessController::class, 'deleteBussiness']);
Route::post('/add_another_user_business', [BussinessController::class, 'add_another_user_business']);
Route::post('/remove_shop_connection', [BussinessController::class, 'remove_shop_connection']);


Route::post('/searchcustomerlist', [CustomerController::class, 'searchcustomerlist']);
Route::post('/customerlist', [CustomerController::class, 'customerlist']);
Route::post('/createcustomer', [CustomerController::class, 'createcustomer']);
Route::post('/showcustomer', [CustomerController::class, 'showcustomer']);
Route::post('/updatecustomer', [CustomerController::class, 'updatecustomer']);
Route::post('/deletecustomer', [CustomerController::class, 'deletecustomer']);

Route::post('/statelist', [LocationController::class, 'statelistByCountry']);
Route::post('/districtlist', [LocationController::class, 'districtlistByState']);
Route::post('/countrylist', [LocationController::class, 'Countrylist']);


Route::post('/productcategorylist', [ProductcategoryController::class, 'productcategorylist']);
Route::post('/createproductcategory', [ProductcategoryController::class, 'createproductcategory']);
Route::post('/updateproductcategory', [ProductcategoryController::class, 'updateproductcategory']);
Route::post('/deletecategory', [ProductcategoryController::class, 'deletecategory']);


Route::post('/expense_category_by_business', [ExpensecategoryController::class, 'expense_category_by_business']);
Route::post('/create_expense_category', [ExpensecategoryController::class, 'create_expense_category']);
Route::post('/update_expense_category', [ExpensecategoryController::class, 'update_expense_category']);
Route::post('/delete_expense_category', [ExpensecategoryController::class, 'delete_expense_category']);


Route::post('/create_expense', [ExpenseController::class, 'create_expense']);


Route::post('/order_list', [StockOrderController::class, 'index']);
Route::post('/create_order', [StockOrderController::class, 'store']);
Route::post('/update_order', [StockOrderController::class, 'update']);
Route::post('/delete_order', [StockOrderController::class, 'destroy']);
Route::post('/change_status', [StockOrderController::class, 'change_order_status']);


Route::post('/today_order_list', [StockOrderController::class, 'Today_Order_list']);
Route::post('/yesterday_order_list', [StockOrderController::class, 'Yesterday_Order_list']);
Route::post('/tomorrow_order_list', [StockOrderController::class, 'Tomorrow_Order_list']);
Route::post('/search_order_list_by_daterange', [StockOrderController::class, 'Order_list_By_Date_Range']);
Route::post('/search_order_list_by_name', [StockOrderController::class, 'Order_list_By_name']);

Route::post('/create_product', [ProductController::class, 'Create']);
Route::post('/productvariantlist', [ProductController::class, 'productvariantlist']);
Route::post('/add_more_products', [ProductController::class, 'AddMoreProducts']);
Route::post('/product_added_records_list', [ProductController::class, 'product_variant_added_record_list']);
Route::post('/addProduct_Variant', [ProductController::class, 'AddProduct_Variant']);
Route::post('/getProductsWithVariants', [ProductController::class, 'getProductsWithVariants']);
Route::post('/getProductspurchasinglist', [ProductController::class, 'getProductspurchasinglist']);
Route::post('/getProductslist', [ProductController::class, 'getProductslist']);



Route::post('/new_sale_voucher', [SaleVoucherController::class, 'new_sale_voucher']);
Route::post('/get_sales_vouchers', [SaleVoucherController::class, 'getSales_vouchers']);
Route::post('/get_todaySales_vouchers', [SaleVoucherController::class, 'getTodaySales_vouchers']);


Route::get('/uom_list', [UOMController::class, 'UOMList']);
Route::post('/new_uom', [UOMController::class, 'New_UOM']);



