<!DOCTYPE html>
<html lang="en">
  <head>
    <title>Golden Myanmar</title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

    <link href="https://fonts.googleapis.com/css?family=Muli:300,400,700|Playfair+Display:400,700,900" rel="stylesheet">

    <link rel="stylesheet" href="{{ asset('website') }}/fonts/icomoon/style.css">
    <link rel="stylesheet" href="{{ asset('website') }}/css/bootstrap.min.css">
    <link rel="stylesheet" href="{{ asset('website') }}/css/magnific-popup.css">
    <link rel="stylesheet" href="{{ asset('website') }}/css/jquery-ui.css">
    <link rel="stylesheet" href="{{ asset('website') }}/css/owl.carousel.min.css">
    <link rel="stylesheet" href="{{ asset('website') }}/css/owl.theme.default.min.css">
    <link rel="stylesheet" href="{{ asset('website') }}/css/bootstrap-datepicker.css">
    <link rel="stylesheet" href="{{ asset('website') }}/fonts/flaticon/font/flaticon.css">
    <link rel="stylesheet" href="{{ asset('website') }}/css/aos.css">

    <link rel="stylesheet" href="{{ asset('website') }}/css/style.css">
    <style>
      .pagination {
        margin-bottom: 0 !important;
      }
    </style>
  </head>
  <body>

  <div class="site-wrap">
    <div class="site-mobile-menu">
      <div class="site-mobile-menu-header">
        <div class="site-mobile-menu-close mt-3">
          <span class="icon-close2 js-menu-toggle"></span>
        </div>
      </div>
      <div class="site-mobile-menu-body"></div>
    </div>
    <header class="site-navbar" role="banner" style="box-shadow: rgba(100, 100, 111, 0.2) 0px 7px 29px 0px;">
      <div class="container-fluid">
        <div class="row align-items-center">

          <div class="col-12 search-form-wrap js-search-form">
            <form method="get" action="#">
              <input type="text" id="s" class="form-control" placeholder="Search...">
              <button class="search-btn" type="submit"><span class="icon-search"></span></button>
            </form>
          </div>

          <div class="col-4 site-logo">
            <a href="/" class="text-black h2 mb-0">Golden Myanmar</a>
          </div>

          <div class="col-8 text-right" >
            <nav class="site-navigation" role="navigation">
              <ul class="site-menu js-clone-nav mr-auto d-none d-lg-block mb-0">
              <li><a href="/">Home</a></li>
                @foreach($categories as $category)
                <li><a href="{{ route('website.category', ['slug' => $category->slug]) }}">{{ $category->name }}</a></li>
                @endforeach
                <li><a href="/contact">Contact Us</a></li>
              </ul>
            </nav>
            <a href="#" class="site-menu-toggle js-menu-toggle text-black d-inline-block d-lg-none"><span class="icon-menu h3"></span></a></div>
          </div>

      </div>
    </header>

    @yield('content')

    <style>
  .site-footer {
    background-color: #333;
    padding: 20px 0;
    color: #ddd;
    font-family: 'Arial', sans-serif;
    font-size: 0.9rem;
  }

  .site-footer a {
    color: #fff;
    text-decoration: none;
    transition: color 0.3s ease;
  }

  .site-footer a:hover {
    color: #f1c40f;
  }

  .site-footer .footer-heading {
    color: #f1c40f;
    font-size: 1.1rem;
    margin-bottom: 10px;
  }

  .site-footer .container {
    max-width: 1200px;
    margin: 0 auto;
  }

  .site-footer .row {
    display: flex;
    justify-content: space-between;
    align-items: flex-start;
    flex-wrap: wrap;
  }

  .site-footer .col {
    flex-basis: calc(33.333% - 10px);
    margin-bottom: 20px;
    padding: 0 10px;
  }

  .site-footer p {
    line-height: 1.6;
    margin-bottom: 10px;
  }

  .site-footer .social-icons a {
    margin-right: 10px;
    color: #ddd;
    font-size: 1.1rem;
  }

  .site-footer .social-icons a:hover {
    color: #f1c40f;
  }

  .site-footer .text-center {
    text-align: center;
    margin-top: 20px;
  }

  @media (max-width: 768px) {
    .site-footer .col {
      flex-basis: 100%;
      text-align: center;
    }

    .site-footer .text-center {
      margin-top: 10px;
    }
  }
</style>

<div class="site-footer">
  <div class="container">
    <div class="row">
      <div class="col">
        <h3 class="footer-heading">About Us</h3>
        <img src="https://i.pinimg.com/564x/7d/6a/c4/7d6ac452815ed590102c73285e2db3e0.jpg" style="width: 171px;"/>
        <p>{{ $setting->description }}</p>
      </div>
      <div class="col">
        <h3 class="footer-heading">Quick Links</h3>
        <ul class="list-unstyled">
          <li><a href="{{ route('website') }}">Home</a></li>
          <li><a href="{{ route('website.about') }}">About Us</a></li>
          <li><a href="{{ route('website.contact') }}">Contact Us</a></li>
          @foreach($categories as $category)
            <li><a href="{{ route('website.category', ['slug' => $category->slug]) }}">{{ $category->name }}</a></li>
          @endforeach
        </ul>
      </div>
      <div class="col">
  <h3 class="footer-heading">Connect With Us</h3>
  <div class="social-icons">
    @if($setting->facebook)<a target="_blank" href="{{ $setting->facebook }}"><span class="icon-facebook"></span></a> @endif
    @if($setting->twitter)<a target="_blank" href="{{ $setting->twitter }}"><span class="icon-twitter"></span></a> @endif
    @if($setting->instagram)<a target="_blank" href="{{ $setting->instagram }}"><span class="icon-instagram"></span></a> @endif
    @if($setting->reddit)<a target="_blank" href="{{ $setting->reddit }}"><span class="icon-rss"></span></a> @endif
    @if($setting->email)<a target="_blank" href="{{ $setting->email }}"><span class="icon-envelope"></span></a> @endif
  </div>

  <div class="contact-info mt-3">
    <p><span class="icon-envelope"></span> <a href="mailto:kosithu8255@gmail.com">kosithu8255@gmail.com</a></p>
    <p><span class="icon-location"></span> Bangkok, Thailand</p>
  </div>
</div>

    </div>
    <div class="row">
      <div class="col-12 text-center">
        <p>
          {{ $setting->copyright }} | Made with <i class="icon-heart text-danger"></i> by Golden Myanmar!
          <br>Developed by Golden Myanmar!
        </p>
      </div>
    </div>
  </div>
</div>

  </div>

  <script src="{{ asset('website') }}/js/jquery-3.3.1.min.js"></script>
  <script src="{{ asset('website') }}/js/jquery-migrate-3.0.1.min.js"></script>
  <script src="{{ asset('website') }}/js/jquery-ui.js"></script>
  <script src="{{ asset('website') }}/js/popper.min.js"></script>
  <script src="{{ asset('website') }}/js/bootstrap.min.js"></script>
  <script src="{{ asset('website') }}/js/owl.carousel.min.js"></script>
  <script src="{{ asset('website') }}/js/jquery.stellar.min.js"></script>
  <script src="{{ asset('website') }}/js/jquery.countdown.min.js"></script>
  <script src="{{ asset('website') }}/js/jquery.magnific-popup.min.js"></script>
  <script src="{{ asset('website') }}/js/bootstrap-datepicker.min.js"></script>
  <script src="{{ asset('website') }}/js/aos.js"></script>

  <script src="{{ asset('website') }}/js/main.js"></script>
  @yield('script')
  </body>
</html>
