<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\User;
use App\Qrcodedata;
use App\Productdata;
use App\Transporter;

use App\Package;
use App\Truck;
use Illuminate\Support\Facades\DB;


class QrcodedataController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
// productdata

public function productdata()
{
    // Retrieve only 'id' and 'name' columns from Productdata
    $products = Productdata::select('id', 'name')->get();

    // Return the data as a JSON response
    return response()->json([
        'message' => 'Products retrieved successfully.',
        'data' => $products
    ]);
}



public function transporter()
{
    // Retrieve only 'id' and 'name' columns from Productdata
    $products = Transporter::select('id', 'name')->get();

    // Return the data as a JSON response
    return response()->json([
        'message' => 'Transporter retrieved successfully.',
        'data' => $products
    ]);
}


public function package()
{
    // Retrieve only 'id' and 'name' columns from Productdata
    $products = Package::select('id', 'name')->get();

    // Return the data as a JSON response
    return response()->json([
        'message' => 'Package retrieved successfully.',
        'data' => $products
    ]);
}


    public function index()
{

    $qrcodedata = Qrcodedata::all();


    return response()->json([
        'message' => 'Qrcodedata fetched successfully',
        'data' => $qrcodedata
    ]);
}

public function productiondata(Request $request)
{
    $validated = $request->validate([
        'stat_pallet' => 'required',
        'end_pallet' => 'required',
        'product_type' => 'required',
        'production_line' => 'required',
        'package' => 'required',
        'volue' => 'required',
        'unit' => 'required',
        'totle' => 'required',
    ]);

    // Find the last pallet number in the database
    $lastProduct = Product::latest('id')->first();
    $lastPalletNumber = $lastProduct ? intval(substr($lastProduct->stat_pallet, 4)) : 0;

    // Determine the range for the new products
    $startPallet = $lastPalletNumber + 1; // Start after the last pallet
    $endPallet = $startPallet + ($validated['end_pallet'] - $validated['stat_pallet']);

    $products = [];
    for ($i = $startPallet; $i <= $endPallet; $i++) {
        $products[] = [
            'stat_pallet' => sprintf('PLT-%03d', $i), // Format as PLT-001, PLT-002, etc.
            'end_pallet' => sprintf('PLT-%03d', $i),
            'product_type' => $validated['product_type'],
            'production_line' => $validated['production_line'],
            'package' => $validated['package'],
            'volue' => $validated['volue'],
            'unit' => $validated['unit'],
            'totle' => $validated['totle'],
            'created_at' => now(),
            'updated_at' => now(),
        ];
    }

    // Bulk insert the products
    Product::insert($products);

    return response()->json([
        'success' => true,
        'data' => $products,
    ], 200);
}





public function products(Request $request)
{
    $perPage = $request->query('per_page', 10);
    $qrcodedata = Product::paginate($perPage);

    return response()->json([
        'message' => 'Products retrieved successfully.',
        'data' => $qrcodedata
    ]);
}




public function productdelete(Request $request)
{
    try {
        // Validate the incoming request
        $request->validate([
            'id' => 'required|integer|exists:products,id', // Ensure the ID exists in the products table
        ]);

        // Fetch and delete the product
        $product = Product::findOrFail($request->id);
        $product->delete();

        return response()->json([
            'success' => true,
            'message' => 'Product deleted successfully.',
        ], 200);
    } catch (\Exception $e) {
        // Handle any errors
        return response()->json([
            'success' => false,
            'message' => 'Failed to delete product.',
            'error' => $e->getMessage(),
        ], 500);
    }
}

public function qrocdedatastatus()
{
    $qrcodedatastatus = DB::table('qrcodedatas')
    ->select('*') // Select all columns (you can specify columns if needed)
    ->whereRaw('status = ?', [0])
    ->get();

return response()->json([
    'message' => 'Qrcodedata fetched successfully',
    'data' => $qrcodedatastatus
]);
}




public function datatimesearch(Request $request)
{
    $query = Qrcodedata::query();

    if ($request->filled('start_date') && $request->filled('end_date')) {
        $query->whereBetween(DB::raw('DATE(created_at)'), [
            $request->start_date,
            $request->end_date
        ]);
    }

    $qrcodedata = $query->get();

    return response()->json([
        'message' => 'Qrcodedata fetched successfully',
        'data' => $qrcodedata
    ]);
}



public function usernamesearch(Request $request)
{
    // Validate that driver_name is provided
    $request->validate([
        'driver_name' => 'required|string',
    ]);

    // Search in the database using the driver_name column
    $users = DB::table('qrcodedatas')
        ->where('customer_name', 'LIKE', '%' . $request->driver_name . '%')
        ->get();

    return response()->json([
        'message' => 'Users fetched successfully',
        'data' => $users
    ]);
}



public function namealldatasearch()
{
    // Retrieve all unique driver names from the qrcodedatas table
    $driverNames = DB::table('qrcodedatas')
        ->select('driver_name') // Select only the driver_name column
        ->distinct() // Ensure unique values only
        ->get();

    return response()->json([
        'message' => 'Driver names fetched successfully',
        'data' => $driverNames
    ]);
}


public function carnumbersearch()
{
    // Retrieve all unique driver names from the qrcodedatas table
    $driverNames = DB::table('qrcodedatas')
        ->select('car_number') // Select only the driver_name column
        ->distinct() // Ensure unique values only
        ->get();

    return response()->json([
        'message' => 'car number  names fetched successfully',
        'data' => $driverNames
    ]);
}


public function drivernamesearch()
{
    // Retrieve all unique driver names from the qrcodedatas table
    $driverNames = DB::table('qrcodedatas')
        ->select('driver_name') // Select only the driver_name column
        ->distinct() // Ensure unique values only
        ->get();

    return response()->json([
        'message' => 'driver_name  number  names fetched successfully',
        'data' => $driverNames
    ]);
}


public function customernamesearch()
{
    // Retrieve all unique driver names from the qrcodedatas table
    $driverNames = DB::table('qrcodedatas')
        ->select('customer_name') // Select only the driver_name column
        ->distinct() // Ensure unique values only
        ->get();

    return response()->json([
        'message' => 'customer_name  number  names fetched successfully',
        'data' => $driverNames
    ]);
}







public function getrrack()
{

    $qrcodedata = Truck::all();


    return response()->json([
        'message' => 'Qrcodedata fetched successfully',
        'data' => $qrcodedata
    ]);
}


    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(Request $request)
    {
        // Validate the incoming request
        $validatedData = $request->validate([
            'car_number' => 'required|string|max:255',
            'driver_name' => 'required|string|max:255',
            'customer_name' => 'required|string|max:255',
            'truck' => 'required|string|max:255',
            'product' => 'required',
            'package' => 'required',
            'quanity' => 'required',
            'unit' => 'required',
            'remark' => 'required',
            'transpoter' => 'required',
            'ordernumber' => 'required|string|max:255', // Add validation for ordernumber
        ]);

        // Add default status value
        $validatedData['status'] = 0;

        // Create the Qrcodedata record
        $qrcodedata = Qrcodedata::create($validatedData);

        // Return a JSON response
        return response()->json([
            'message' => 'Qrcodedata created successfully',
            'data' => $qrcodedata
        ], 201);
    }


public function qrocdeupdate(Request $request)
{
    // Validate the incoming request
    $validatedData = $request->validate([
        'id' => 'required|integer|exists:qrcodedatas,id', // Ensure the ID exists in the table
        'qr_status' => 'required|string|max:255', // Allow any string for qr_status
    ]);

    // Find the record by ID
    $qrcodeData = Qrcodedata::find($validatedData['id']);

    // Update the qr_status column
    $qrcodeData->qr_status = $validatedData['qr_status'];
    $qrcodeData->save();

    // Return the updated record as JSON
    return response()->json([
        'message' => 'Qrcode data updated successfully',
        'data' => $qrcodeData
    ], 200);
}





    public function multicreatedata(Request $request)
{
    // Validate that the request contains an array of data
    $validatedData = $request->validate([
        'data' => 'required|array', // Ensure 'data' is an array
        'data.*.car_number' => 'required|string|max:255',
        'data.*.driver_name' => 'required|string|max:255',
        'data.*.customer_name' => 'required|string|max:255',
        'data.*.truck' => 'required|string|max:255',
    ]);

    // Use the validated 'data' to create multiple records
    $createdRecords = [];
    foreach ($validatedData['data'] as $record) {
        // Add the status field with a default value of 1
        $record['status'] = 1;

        // Create the record and add it to the createdRecords array
        $createdRecords[] = Qrcodedata::create($record);
    }

    // Return the created records as JSON
    return response()->json([
        'message' => 'Qrcodedata created successfully',
        'data' => $createdRecords
    ], 201);
}






    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
