@extends('layouts.admin')

@section('content')
<!-- Content Header (Page header) -->
<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0 text-dark">Create User</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="{{ route('website') }}">Home</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('user.index') }}">User list</a></li>
                    <li class="breadcrumb-item active">Create User</li>
                </ol>
            </div>
        </div>
    </div>
</div>

<!-- Main content -->
<div class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header">
                        <div class="d-flex justify-content-between align-items-center">
                            <h3 class="card-title">Create User</h3>
                            <a href="{{ route('user.index') }}" class="btn btn-primary">Go Back to User List</a>
                        </div>
                    </div>
                    <div class="card-body p-0">
                        <div class="row">
                            <div class="col-12 col-lg-6 offset-lg-3 col-md-8 offset-md-2">
                                <form action="{{ route('user.store') }}" method="POST">
                                    @csrf
                                    <div class="card-body">
                                        @include('includes.errors')

                                        <div class="form-group">
                                            <label for="name">User Name</label>
                                            <input type="text" name="name" class="form-control" id="name" placeholder="Enter name">
                                        </div>

                                        <div class="form-group">
                                            <label for="email">User Email</label>
                                            <input type="email" name="email" class="form-control" id="email" placeholder="Enter email">
                                        </div>

                                        <div class="form-group">
                                            <label for="categories">Post Category</label>
                                            <div class="d-flex flex-wrap">
                                                @foreach($categories as $category)
                                                    <div class="custom-control custom-checkbox" style="margin-right: 20px">
                                                        <input class="custom-control-input" name="categories[]" type="checkbox" id="category{{ $category->id }}" value="{{ $category->id }}">
                                                        <label for="category{{ $category->id }}" class="custom-control-label">{{ $category->name }}</label>
                                                    </div>
                                                @endforeach
                                            </div>
                                        </div>

                                        <div class="form-group">
                                            <label for="password">User Password</label>
                                            <input type="password" name="password" class="form-control" id="password" placeholder="Enter password">
                                        </div>

                                        <!-- Date-Time Picker -->
                                        <div class="form-group">
                                            <label for="email_verified_at">Expiry date</label>
                                            <input type="date" name="email_verified_at" class="form-control" id="email_verified_at">
                                        </div>


                                        <!-- Select Field for Download -->
                                        <div class="form-group">
                                            <label for="download">Download</label>
                                            <select name="download" class="form-control" id="download">
                                                <option value="null">No</option>
                                                <option value="1">Yes</option>
                                            </select>
                                        </div>

                                    </div>
                                    <div class="card-footer">
                                        <button type="submit" class="btn btn-lg btn-primary">Submit</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
